(*
 * TrackerPositionCB.m3 -- the autogenerated callback object
 *)

MODULE TrackerPositionCB;

IMPORT TrackerPosition, SharedObjRep, SharedObjStubLib,
       WeakRef, WeakerRef, WeakRefList, WeakRefListFuncs;

REVEAL 
  T = Public BRANDED OBJECT 
    obj: TrackerPosition.T;
  OVERRIDES
    init := InitCallback;
    pre_set := SetNoOp;
    pre_anyChange := AnyChangeNoOp;
    post_set := SetNoOp;
    post_anyChange := AnyChangeNoOp;
  END;

PROCEDURE InitCallback(self: T; obj: TrackerPosition.T): T =
  VAR
    wref := NEW(WeakerRef.T, weakRef := WeakRef.FromRef(self, CleanupCB), 
                ready := TRUE);
  BEGIN
    self.obj := obj;
    SharedObjStubLib.AcquireWriteLock(obj);
    TRY
      obj.callbacks := WeakRefList.Cons(wref, obj.callbacks);
    FINALLY
      SharedObjStubLib.ReleaseWriteLock(obj);
    END;
    RETURN self;
  END InitCallback; 

PROCEDURE CleanupCB (READONLY wref: WeakRef.T; ref: REFANY) =
  VAR
    cb             := NARROW(ref, T);
    weakerRef := NEW(WeakerRef.T, weakRef := wref);
  BEGIN
    SharedObjStubLib.AcquireWriteLock(cb.obj);
    TRY
      (* Callback is gone, so delete it. *)
      EVAL WeakRefListFuncs.DeleteD(cb.obj.callbacks, weakerRef);
    FINALLY
      SharedObjStubLib.ReleaseWriteLock(cb.obj);
    END;
  END CleanupCB;

PROCEDURE AnyChangeNoOp(<*UNUSED*> self: T; 
                        <*UNUSED*> READONLY obj: TrackerPosition.T) =
  BEGIN
    (* Default does nothing. *)
  END AnyChangeNoOp;

PROCEDURE SetNoOp(<*UNUSED*> self: T; 
                  <*UNUSED*> READONLY obj: TrackerPosition.T; 
                  <*UNUSED*> READONLY val: TrackerPosition.Data): BOOLEAN =
  BEGIN
    (* Default does nothing. *)
    RETURN FALSE;
  END SetNoOp;

BEGIN
END TrackerPositionCB.
