(* Copyright 1996-2000, Critical Mass, Inc. All Rights Reserved. *)
(* See file COPYRIGHT-CMASS for details. *)

INTERFACE HoverVBT;

(* A "HoverVBT" is a filter that can notify its descendants if
   the mouse is sitting over them. *)
   
IMPORT Filter, Time, VBT;

TYPE 
  T <: Filter.T;

TYPE
  CallBack = PROCEDURE (v: VBT.T;  ref: REFANY);

PROCEDURE New (ch: VBT.T): T;
(* == NEW(T).init(ch) *)

PROCEDURE Register (v: VBT.T;  delay: Time.T;  cb: CallBack;  ref: REFANY);
(* Registers "v" so that if an ancestor of "v" is a hover vbt and it notices
   the mouse sitting over "v" for at least "delay" seconds, "cb(v,ref)"
   will be called.  The callback calls generated by a given hover vbt are
   serialized and made with no locks held.  "CallBack" procedures must
   be top-level procedures.  At most one registration is maintained for
   a vbt and it is determined by the last call to "Register". *)

END HoverVBT.

