(* This file was generated by the program sharedgen *)

MODULE TrackerPositionSO EXPORTS TrackerPosition;

IMPORT TrackerPositionCB, TrackerPositionF;
IMPORT EventStubLib, EventProtocol, Rd, Wr, SharedObj, SharedObjRep,
       SharedObjStubLib, Thread, ThreadF, Logitech, Event, Pickle,
       WeakRef, ObjectSpace, IO, PickleStubs;

CONST Protocol: EventProtocol.StubProtocol = 1;

TYPE Methods = {set};

REVEAL
  T = S BRANDED "Shared " & Brand OBJECT
    OVERRIDES
      init        := Shared_init;
      set         := Shared_set;
      get         := Shared_get;
      applyUpdate := ApplyUpdate;
    END;

PROCEDURE Shared_init (self: T): SharedObj.T =
  BEGIN
    self := S.init(self);
    RETURN self;
  END Shared_init;

PROCEDURE Shared_get (self: T;
                      VAR val_arg: Logitech.TrackerPosition)
  RAISES {SharedObj.Error, Thread.Alerted} =
  BEGIN
    IF NOT self.ok THEN SharedObjStubLib.RaiseDeadObject(); END;
    TRY
      SharedObjStubLib.AcquireReadLock(self);
      S.get(self, val_arg);
    FINALLY
      SharedObjStubLib.ReleaseReadLock(self);
    END
  END Shared_get;

PROCEDURE Shared_set (self   : T; READONLY val_arg: Data)
  RAISES {SharedObj.Error} =
  VAR m: SharedObjStubLib.Handle;
      id := ThreadF.MyId();
  BEGIN
    IF NOT self.ok THEN SharedObjStubLib.RaiseDeadObject(); END;
    IF self.updating = id THEN SharedObjStubLib.RaiseRecursiveUpdate(); END;
    TRY
      m := SharedObjStubLib.StartCall(self, Protocol);
      IF NOT m.local THEN
        EventStubLib.OutInt32(m.eh, ORD(Methods.set));
        EventStubLib.OutLongreal(m.eh, val_arg.time);
        EventStubLib.OutBoolean(m.eh, val_arg.fringe);
        EventStubLib.OutBoolean(m.eh, val_arg.out);
        EventStubLib.OutReal(m.eh, val_arg.position.x);
        EventStubLib.OutReal(m.eh, val_arg.position.y);
        EventStubLib.OutReal(m.eh, val_arg.position.z);
        EventStubLib.OutReal(m.eh, val_arg.rotation_q.a);
        EventStubLib.OutReal(m.eh, val_arg.rotation_q.b);
        EventStubLib.OutReal(m.eh, val_arg.rotation_q.c);
        EventStubLib.OutReal(m.eh, val_arg.rotation_q.d);
        FOR i0 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
          FOR i1 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
            EventStubLib.OutReal(m.eh, val_arg.rotation_m[i0][i1]);
          END;
        END;
        EventStubLib.OutBoolean(m.eh, val_arg.suspend);
        EventStubLib.OutBoolean(m.eh, val_arg.left);
        EventStubLib.OutBoolean(m.eh, val_arg.middle);
        EventStubLib.OutBoolean(m.eh, val_arg.right);
      END;
      SharedObjStubLib.SequenceCall(m);
      TRY
        SharedObjStubLib.AcquireWriteLock(self);
        self.updating := ThreadF.MyId();
        Callback_Pre_set(self, val_arg);
        S.set(self, val_arg);
        Callback_Post_set(self, val_arg);
      FINALLY
        self.updating := -1;
        SharedObjStubLib.ReleaseWriteLock(self);
        SharedObjStubLib.EndCall(m);
      END
    EXCEPT
    | Rd.Failure (ec) => SharedObjStubLib.RaiseCommFailure(ec);
    | Wr.Failure (ec) => SharedObjStubLib.RaiseCommFailure(ec);
    | Thread.Alerted => SharedObjStubLib.RaiseAlerted();
    END;
  END Shared_set;

PROCEDURE ApplyUpdate(self: T; ev : Event.T; h : EventStubLib.Handle)
  RAISES {SharedObj.Error, SharedObj.Fatal, Event.Error, Rd.Failure,
          Thread.Alerted} =
  BEGIN
    IF ev.prot # Protocol THEN EventStubLib.RaiseUnmarshalFailure() END;
    WITH meth = EventStubLib.InInt32(h) DO
      TRY
        SharedObjStubLib.AcquireWriteLock(self);
        CASE meth OF
        | ORD(Methods.set) => Stub_set(self, h);
        ELSE
          EventStubLib.RaiseUnmarshalFailure();
        END;
      FINALLY
        SharedObjStubLib.ReleaseWriteLock(self);
      END;
    END;
  END ApplyUpdate;

PROCEDURE Stub_set (self: T; h: EventStubLib.Handle)
  RAISES {SharedObj.Error, Event.Error, SharedObj.Fatal, Rd.Failure,
          Thread.Alerted} =
  VAR val_arg: Logitech.TrackerPosition;
  BEGIN

      val_arg.time := EventStubLib.InLongreal(h);
      val_arg.fringe := EventStubLib.InBoolean(h);
      val_arg.out := EventStubLib.InBoolean(h);
      val_arg.position.x := EventStubLib.InReal(h);
      val_arg.position.y := EventStubLib.InReal(h);
      val_arg.position.z := EventStubLib.InReal(h);
      val_arg.rotation_q.a := EventStubLib.InReal(h);
      val_arg.rotation_q.b := EventStubLib.InReal(h);
      val_arg.rotation_q.c := EventStubLib.InReal(h);
      val_arg.rotation_q.d := EventStubLib.InReal(h);
      FOR i0 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
        FOR i1 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
          val_arg.rotation_m[i0][i1] := EventStubLib.InReal(h);
        END;
      END;
      val_arg.suspend := EventStubLib.InBoolean(h);
      val_arg.left := EventStubLib.InBoolean(h);
      val_arg.middle := EventStubLib.InBoolean(h);
      val_arg.right := EventStubLib.InBoolean(h);

    Callback_Pre_set(self, val_arg);
    S.set(self, val_arg);
    Callback_Post_set(self, val_arg);
  END Stub_set;

PROCEDURE Callback_Pre_set (READONLY self: T; 
                            READONLY val_arg: Logitech.TrackerPosition) =
  VAR cbs := self.callbacks;
  BEGIN
    WHILE cbs # NIL DO
      IF cbs.head.ready THEN
        WITH ref = WeakRef.ToRef(cbs.head.weakRef) DO
          IF ref # NIL THEN
            WITH cb = NARROW(ref, TrackerPositionCB.T) DO
              IF NOT cb.pre_set(self, val_arg) THEN
                cb.pre_anyChange(self);
              END;
            END;
          END;
        END;
      END;
      cbs := cbs.tail;
    END;
  END Callback_Pre_set; 

PROCEDURE Callback_Post_set (READONLY self: T; 
                             READONLY val_arg: Logitech.TrackerPosition) =
  VAR cbs := self.callbacks;
  BEGIN
    WHILE cbs # NIL DO
      IF cbs.head.ready THEN
        WITH ref = WeakRef.ToRef(cbs.head.weakRef) DO
          IF ref # NIL THEN
            WITH cb = NARROW(ref, TrackerPositionCB.T) DO
              IF NOT cb.post_set(self, val_arg) THEN
                cb.post_anyChange(self);
              END;
            END;
          END;
        END;
      END;
      cbs := cbs.tail;
    END;
  END Callback_Post_set; 

(* The pickling routine for this shared object.   We will register a
   pickler for TrackerPosition.S, and then handle both S and T.
   Pickling subtypes of T is illegal. *)

TYPE
  TSpecial = Pickle.Special OBJECT
             OVERRIDES
               write := WriteT;
               read  := ReadT
             END;

PROCEDURE WriteT (<*UNUSED*> ts: TSpecial; ref: REFANY; wr: Pickle.Writer)
  RAISES {Pickle.Error, Wr.Failure, Thread.Alerted} =
  VAR
    obj: S;
    tc := TYPECODE(ref);
  BEGIN
    IO.Put("Pickle.Special for TrackerPosition.S\n");
    IF tc # TYPECODE(S) AND tc # TYPECODE(T) THEN
      RAISE Pickle.Error("Can't pickle subtypes of TrackerPosition.T");
    END;
    obj := NARROW(ref, S);

    IO.Put("Pickle.Special.wr for TrackerPosition.S: writing shared obj\n");
    wr.writeType(tc);
    SharedObjStubLib.StartWritePickle(obj, wr);
    PickleStubs.OutLongreal(wr, obj.data.time);
    PickleStubs.OutBoolean(wr, obj.data.fringe);
    PickleStubs.OutBoolean(wr, obj.data.out);
    PickleStubs.OutReal(wr, obj.data.position.x);
    PickleStubs.OutReal(wr, obj.data.position.y);
    PickleStubs.OutReal(wr, obj.data.position.z);
    PickleStubs.OutReal(wr, obj.data.rotation_q.a);
    PickleStubs.OutReal(wr, obj.data.rotation_q.b);
    PickleStubs.OutReal(wr, obj.data.rotation_q.c);
    PickleStubs.OutReal(wr, obj.data.rotation_q.d);
    FOR i0 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
      FOR i1 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
        PickleStubs.OutReal(wr, obj.data.rotation_m[i0][i1]);
      END;
    END;
    PickleStubs.OutBoolean(wr, obj.data.suspend);
    PickleStubs.OutBoolean(wr, obj.data.left);
    PickleStubs.OutBoolean(wr, obj.data.middle);
    PickleStubs.OutBoolean(wr, obj.data.right);
    SharedObjStubLib.EndWritePickle(obj, wr);

    IO.Put("Pickle.Special.wr for TrackerPosition.S: wrote shared obj\n");
  END WriteT;

PROCEDURE ReadT (<*UNUSED*> ts: TSpecial; rd: Pickle.Reader; id: Pickle.RefID):
  REFANY RAISES {Pickle.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  VAR
    space: ObjectSpace.T;
    obj : S;
    tc: INTEGER;
  BEGIN
    tc := rd.readType();
    IF tc = TYPECODE(T) THEN
      IO.Put("Pickle.Special.rd for TrackerPosition.S: shared obj\n");
      obj := NEW(T);
    ELSIF tc = TYPECODE(S) THEN
      IO.Put("Pickle.Special.rd for TrackerPosition.S: non-shared obj\n");
      obj := NEW(S);
    ELSE
      RAISE Pickle.Error("Can't unpickle subtypes of TrackerPosition.T");
    END;

    IO.Put("Pickle.Special.rd for TrackerPosition.S: reading space\n");
    space := rd.read();
    IO.Put("Pickle.Special.rd for TrackerPosition.S: reading shared obj\n");

    SharedObjStubLib.StartReadPickle(obj, rd, space);
    obj.data.time := PickleStubs.InLongreal(rd);
    obj.data.fringe := PickleStubs.InBoolean(rd);
    obj.data.out := PickleStubs.InBoolean(rd);
    obj.data.position.x := PickleStubs.InReal(rd);
    obj.data.position.y := PickleStubs.InReal(rd);
    obj.data.position.z := PickleStubs.InReal(rd);
    obj.data.rotation_q.a := PickleStubs.InReal(rd);
    obj.data.rotation_q.b := PickleStubs.InReal(rd);
    obj.data.rotation_q.c := PickleStubs.InReal(rd);
    obj.data.rotation_q.d := PickleStubs.InReal(rd);
    FOR i0 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
      FOR i1 := FIRST([0 .. 3]) TO LAST([0 .. 3]) DO
        obj.data.rotation_m[i0][i1] := PickleStubs.InReal(rd);
      END;
    END;
    obj.data.suspend := PickleStubs.InBoolean(rd);
    obj.data.left := PickleStubs.InBoolean(rd);
    obj.data.middle := PickleStubs.InBoolean(rd);
    obj.data.right := PickleStubs.InBoolean(rd);

    IF tc = TYPECODE(T) THEN
      IO.Put("Pickle.Special.rd for TrackerPosition.S: setup shared obj\n");
      obj := SharedObjStubLib.SetupNewCopy(obj, rd, id, space);
    END;
    IO.Put("Pickle.Special.rd for TrackerPosition.S: done\n");
    RETURN obj;
  END ReadT;

BEGIN
  Pickle.RegisterSpecial(NEW(TSpecial, sc := TYPECODE(S)));
END TrackerPositionSO.
